/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.tools.journal.drawers;

import com.agricraft.agricraft.api.config.StatsConfig;
import com.agricraft.agricraft.api.stat.AgriStatRegistry;
import com.agricraft.agricraft.api.tools.journal.JournalData;
import com.agricraft.agricraft.api.tools.journal.JournalPageDrawer;
import com.agricraft.agricraft.common.item.journal.GeneticsPage;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GeneticsPageDrawer
implements JournalPageDrawer<GeneticsPage> {
    private final ResourceLocation DNA_SCHEMATIC = new ResourceLocation("agricraft", "textures/gui/journal/dna_schematic.png");
    private final Component CROP_BREEDING = Component.m_237115_((String)"agricraft.journal.crop_breeding");
    private final Component PARAGRAPH_L_1 = Component.m_237115_((String)"agricraft.journal.crop_breeding.paragraph_1");
    private final Component PARAGRAPH_L_2 = Component.m_237115_((String)"agricraft.journal.crop_breeding.paragraph_2");
    private final Component PARAGRAPH_L_3 = Component.m_237115_((String)"agricraft.journal.crop_breeding.paragraph_3");
    private final Component STATS = Component.m_237115_((String)"agricraft.journal.stats");
    private final Component PARAGRAPH_R_1 = Component.m_237115_((String)"agricraft.journal.stats.paragraph_1");
    private final Component PARAGRAPH_GROWTH = Component.m_237115_((String)"agricraft.journal.stats.growth");
    private final Component PARAGRAPH_GAIN = Component.m_237115_((String)"agricraft.journal.stats.gain");
    private final Component PARAGRAPH_STRENGTH = Component.m_237115_((String)"agricraft.journal.stats.strength");
    private final Component PARAGRAPH_RESISTANCE = Component.m_237115_((String)"agricraft.journal.stats.resistance");
    private final Component PARAGRAPH_FERTILITY = Component.m_237115_((String)"agricraft.journal.stats.fertility");
    private final Component PARAGRAPH_MUTATIVITY = Component.m_237115_((String)"agricraft.journal.stats.mutativity");

    @Override
    public void drawLeftSheet(GuiGraphics guiGraphics, GeneticsPage page, int pageX, int pageY, JournalData journalData) {
        Font font = Minecraft.m_91087_().f_91062_;
        float scale = 0.7f;
        float dx = pageX + 6;
        float dy = pageY + 7 + 10;
        int spacing = 4;
        guiGraphics.m_280614_(font, this.CROP_BREEDING, (int)dx, (int)dy, 0, false);
        Objects.requireNonNull(font);
        dy += 9.0f;
        dy += (float)spacing;
        dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_L_1, dx, dy, scale);
        dy += (float)spacing;
        dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_L_2, dx, dy, scale);
        guiGraphics.m_280163_(this.DNA_SCHEMATIC, (int)dx, (int)(dy += (float)spacing), 0.0f, 0.0f, 96, 32, 96, 32);
        this.drawScaledText(guiGraphics, this.PARAGRAPH_L_3, dx, dy += (float)(spacing + 32), scale);
    }

    @Override
    public void drawRightSheet(GuiGraphics guiGraphics, GeneticsPage page, int pageX, int pageY, JournalData journalData) {
        Font font = Minecraft.m_91087_().f_91062_;
        float dx = pageX + 6;
        float dy = pageY + 10;
        float spacing = 4.0f;
        guiGraphics.m_280614_(font, this.STATS, (int)dx, (int)dy, 0, false);
        Objects.requireNonNull(font);
        dy += 9.0f;
        dy += spacing;
        dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_R_1, dx, dy, 0.7f);
        dy += spacing;
        if (!StatsConfig.growthHidden) {
            dy += (float)this.drawScaledText(guiGraphics, (Component)LangUtils.statName(AgriStatRegistry.getInstance().growthStat()).m_130940_(ChatFormatting.UNDERLINE), dx, dy, 0.7f);
            dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_GROWTH, dx, dy, 0.6f);
            dy += spacing / 2.0f;
        }
        if (!StatsConfig.gainHidden) {
            dy += (float)this.drawScaledText(guiGraphics, (Component)LangUtils.statName(AgriStatRegistry.getInstance().gainStat()).m_130940_(ChatFormatting.UNDERLINE), dx, dy, 0.7f);
            dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_GAIN, dx, dy, 0.6f);
            dy += spacing / 2.0f;
        }
        if (!StatsConfig.strengthHidden) {
            dy += (float)this.drawScaledText(guiGraphics, (Component)LangUtils.statName(AgriStatRegistry.getInstance().strengthStat()).m_130940_(ChatFormatting.UNDERLINE), dx, dy, 0.7f);
            dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_STRENGTH, dx, dy, 0.6f);
            dy += spacing / 2.0f;
        }
        if (!StatsConfig.resistanceHidden) {
            dy += (float)this.drawScaledText(guiGraphics, (Component)LangUtils.statName(AgriStatRegistry.getInstance().resistanceStat()).m_130940_(ChatFormatting.UNDERLINE), dx, dy, 0.7f);
            dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_RESISTANCE, dx, dy, 0.6f);
            dy += spacing / 2.0f;
        }
        if (!StatsConfig.fertilityHidden) {
            dy += (float)this.drawScaledText(guiGraphics, (Component)LangUtils.statName(AgriStatRegistry.getInstance().fertilityStat()).m_130940_(ChatFormatting.UNDERLINE), dx, dy, 0.7f);
            dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_FERTILITY, dx, dy, 0.6f);
            dy += spacing / 2.0f;
        }
        if (!StatsConfig.mutativityHidden) {
            dy += (float)this.drawScaledText(guiGraphics, (Component)LangUtils.statName(AgriStatRegistry.getInstance().mutativityStat()).m_130940_(ChatFormatting.UNDERLINE), dx, dy, 0.7f);
            dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_MUTATIVITY, dx, dy, 0.6f);
        }
    }
}

